/***********************************************************************
 *
 *  Copyright (c) 2008  Broadcom Corporation
 *  All Rights Reserved
 *
<:label-BRCM:2011:proprietary:standard

 This program is the proprietary software of Broadcom Corporation and/or its
 licensors, and may only be used, duplicated, modified or distributed pursuant
 to the terms and conditions of a separate, written license agreement executed
 between you and Broadcom (an "Authorized License").  Except as set forth in
 an Authorized License, Broadcom grants no license (express or implied), right
 to use, or waiver of any kind with respect to the Software, and Broadcom
 expressly reserves all rights in and to the Software and all intellectual
 property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU HAVE
 NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY NOTIFY
 BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.

 Except as expressly set forth in the Authorized License,

 1. This program, including its structure, sequence and organization,
    constitutes the valuable trade secrets of Broadcom, and you shall use
    all reasonable efforts to protect the confidentiality thereof, and to
    use this information only in connection with your use of Broadcom
    integrated circuit products.

 2. TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
    AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
    WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH
    RESPECT TO THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND
    ALL IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY, NONINFRINGEMENT,
    FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
    COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION OR CORRESPONDENCE
    TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF USE OR
    PERFORMANCE OF THE SOFTWARE.

 3. TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR
    ITS LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL,
    INDIRECT, OR EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY
    WAY RELATING TO YOUR USE OF OR INABILITY TO USE THE SOFTWARE EVEN
    IF BROADCOM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES;
    OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT ACTUALLY PAID FOR THE
    SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE LIMITATIONS
    SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF ANY
    LIMITED REMEDY.
:>
 *
 ************************************************************************/

/* \file l2_driver_settings.h
 *
 * \brief File for L2 driver compilation settings
 *
 **************************************************/

/* ///////////////////////////////////////////////////////////////
   //      Select below L2 library options and features         //
   /////////////////////////////////////////////////////////////// */

/**
 *  Default MMV version
 *
 *  Management message version used by default to connect to PLC
 *  devices.
 *  Note: MMV1 requires ENCRYPTION support: L2_DRIVER_ENCRYPTION.
 **/
#define L2_DRIVER_DEFAULT_MMV 2

/**
 *  L2 driver encryption support
 *
 *  Enables support for L2 primitive encryption.
 *  Note: requires DAK generation:  L2_DRIVER_DAK_GENERATION.
 **/
#define L2_DRIVER_ENCRYPTION

/**
 *  Modem Authentication
 *  
 *  Authenticates PC vs modem connection.
 **/
#define L2_DRIVER_AUTHENTICATE

/**
 *  FW upgrade support 
 *  
 *  Allows to upgrade the FW.
 *  Meaningless if PLC SoC has no dedicated flash.
 **/
#undef L2_DRIVER_UPGRADE

/**
 *  DAK generation
 *  
 *  DAK generation feature.
 **/
#define L2_DRIVER_DAK_GENERATION

/**
 *  NMK generation
 *  
 *  NMK generation feature.
 *  Note: requires ENCRYPTION support: L2_DRIVER_ENCRYPTION.
 **/
#define L2_DRIVER_NMK_NID_GENERATION


/**
 *  QoS rules functions
 *
 *  Enable this define in case you want to use QoS functions.
 **/
#undef L2_QOS


/**
 *  APCM_STDB_CMD
 *
 *  Enable Standby command support.
 *  Triggers the standby status, wakeable by button press
 *  or gphy link detection.
 **/
#define L2_DRIVER_APCM_STDBY_CMD


/* ///////////////////////////////////////////////////////////////
   //        End of L2 feature and options selection            //
   /////////////////////////////////////////////////////////////// */
   
   
/* Options dependency check (Do not modify below to select options) */

#if (L2_DRIVER_DEFAULT_MMV==1) && !defined(L2_DRIVER_ENCRYPTION)
  #error MMV=1 requires encryption enabled. Please, enable L2_DRIVER_ENCRYPTION
#endif


#if defined(L2_DRIVER_ENCRYPTION) && !defined(L2_DRIVER_DAK_GENERATION)
  #error L2_DRIVER_ENCRYPTION requires DAK generation enabled. Please enable L2_DRIVER_DAK_GENERATION
#endif

#if defined(L2_DRIVER_NMK_NID_GENERATION) && !defined(L2_DRIVER_ENCRYPTION)
  #error L2_DRIVER_NMK_NID_GENERATION requires DAK generation enabled. Please enable L2_DRIVER_ENCRYPTION
#endif

